### 概述

Modbus 本身是一种信息交换的规范，Modbus TCP则是透过TCP/IP来实现Modbus 的一种方式，因此所有的信息都是通过TCP/IP来传输的；Modbus协议属于 C/S 架构，Modbus Tcp Slave是一种Server用来存放所有要被读取的工业设备数据；

**使用场景**

* Modbus属于C/S架构，在工业上会有Modbus slave作为server来存放所有要被读取的工业设备数据，如温度、湿度、距离等资料，Modbus主站可以通过tcp/ip连接到slave进行通讯；

**整体架构**
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd055add5.png)

* Modbus Tcp是透过TCP/IP来实现Modbus的一种方式，因此所有讯息是透过TCP/IP来传输的，Modbus Tcp Master可以对Slave发送读或者写的指令，Slave收到指令后会回复确认信息，整个Modbus的沟通建立在一来一回的讯息交换上；

**主要功能及产品组件**

注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

* 下表概述了各个产品

| **产品组件**                      | **描述说明**    |
| ----------------------------- | ----------- |
| modbusslave\_0.0.5\_amd64.deb |             |
| modbusslave.library           | 上位机程序使用的库文件 |

---
### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 工智机可以访问互联网；

* 熟悉基础的Linux操作命令；

**安装过程**

**1、工智机端安装Modbus Tcp Slave RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd11337c3.png)


* 修改RTE的配置文件，ComponentManger字段下加入modbusslave

* 重启RTE服务，使新加入的modbusslave被调用

**2、Metafacture安装library**

* 打开Metafacture，点击“工具”  -- “库存储”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd1aad50f.png)

* 点击“安装” -- 选中modbus slave的库文件，点击“打开”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd2dddbdb.png)

* 工程中点击“库管理器” -- “添加库” -- 选中modbus库点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd3abe1b2.png)


**更新安装**

**1、工智机端升级Modbus Tcp Slave RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

* 重启RTE服务，使新升级的modbusslave被调用

**2、Metafacture升级library**

* 打开Metafacture，点击“工具”  -- “库存储”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd7ae2bf5.png)

* 点击“安装” -- 选中要升级的modbus slave的库文件，点击“打开”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd8298ada.png)

* 工程中点击“库管理器” -- “添加库” -- 选中modbus库点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd8b80207.png)


**卸载过程**

**1、工智机端卸载Modbus Tcp Slave RTE组件**

* 工智机上执行命令卸载modbusslave

* 修改RTE的配置文件，ComponentManger字段下去掉modbusslave

* 重启RTE服务

**2、卸载MetaFacture侧的Modbus Tcp slave library**

* MetaFacture界面点击“工具” -- “库存储”&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd9488a19.png)


* 对话框中选中安装的modbus slave的库，点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bd9ada456.png)


---
### 技术说明

**快速启动**

**（一）本例软、硬件配置**

**硬件：**

1. SX5100工智机 MetaOS V24.08.15\_SX5

2. Win10 PC

**软件：**

1. MetaFacutre V1.0.6.3

2. Modbus Poll主站工具

**（二）本例实验要求及原理**

* 实验要求：按照“安装卸载”部分中的“安装过程”配置完成Modbus Tcp Slave环境

**1、实验原理**
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bda398138.png)


* 第三方Modbus Tcp主站通过 TCP 连接向Metafacture Modbus Tcp 从站发送请求，主要包含：功能码、目标寄存器的地址和数量、写操作时的数据；从站收到请求后先检查数据的合法性，然后执行请求的操作，响应主站请求；

* 上位机和工智机使用EtherNet连接。

* 上位机上，MetaFacture下装工程到工智机。工程中会包含下面的试验操作步骤中的配置。

* 工智机与第三方Modbus Tcp主站通过EtherNet连接。

 **（三）本例实验操作步骤**

**1、新建Modbus tcp slave工程的实验步骤如下：**

* POU中声明区域调用modbus tcp slave功能块，配置线圈、离散输入、保持寄存器、输入寄存器各2048点；

* POU中程序区域调用fb\_tcp，配置从站IP地址、端口、线圈地址、保持寄存器地址、离散输入地址、输入寄存器地址；

* 工程运行后即可使用Modbus Poll连接Metafacture Tcp Slave，对从站进行读写操作；主站与从站数据一致；

![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bdaea5531.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bdb5c1b5b.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bdbd3cc00.png)
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bdc3a2093.png)

---
### 创建Modbus Tcp从站

**功能块FB介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/IPuingB0/6800bdcbac484.png)

参数介绍

* 输入参数

| 参数名称                | 参数类型            | 描述                     |
| ------------------- | --------------- | ---------------------- |
| bEnable             | BOOL            | 启动modbus tcp slave     |
| sIpAddr             | STRING          | 设置从站的IP地址              |
| uiIpPort            | UDINT           | 设置从站的端口号               |
| udiTimeOut          | UDINT           | 超时时间                   |
| phyCoil             | POINTER TO BYTE | 从站线圈，可读可写              |
| pbyDiscreteInput    | POINTER TO BYTE | 从站离散输入，只读              |
| pbyHoldingRegisterA | POINTER TO BYTE | 从站保持寄存器，可读可写           |
| pbyInputRegister    | POINTER TO BYTE | 从站输入寄存器，只读             |
| udiRwBitSize        | UDINT           | 以位可读写寻址的最大个数，用于线圈      |
| udiInBitSize        | UDINT           | 以位可读寻址的最大个数，用于离散输入     |
| udiInWordSize       | UDINT           | 以字可读寻址的最大个数，用于输入寄存器    |
| udiRwWordSize       | UDINT           | 以字可读写寻址的最大个数，用于保持寄存器   |
| psMbTest            | INT             | 默认0，Modbus测试用数据，默认不用配置 |

* 输出参数

| 参数名称          | 参数类型            | 描述                           |
| ------------- | --------------- | ---------------------------- |
| bBusy         | BOOL            | 当功能块被激活时，被置为True，一直保持到收到确认信号 |
| bActive       | BOOL            | Modbus从站激活标志位                |
| bConnect      | BOOL            | Modbus连接成功标志位                |
| bError        | BOOL            | 错误标志位。True为报错，False无报错       |
| eRrror        | Modbus Error id | 错误反馈id                       |
| UIRecvCounter | ULINT           | 数据接收计数器                      |
| UISendCounter | ULINT           | 数据发送计数器                      |
| sLocalIp      | STRING          | 本地ip地址                       |
| sClientIp     | STRING          | 客户端ip地址                      |